<?php
/*
 * This is the config file for the theme.
 */

define("TD_THEME_NAME", "Newsmag");
define("TD_THEME_VERSION", "1.7.1");
define("TD_THEME_DOC_URL", "http://forum.tagdiv.com/newsmag-documentation/");
define("TD_THEME_DEMO_URL", "http://demo.tagdiv.com/" . strtolower(TD_THEME_NAME));
define("TD_FEATURED_CAT", "Featured"); //featured cat name
define("TD_FEATURED_CAT_SLUG", "featured"); //featured cat slug
define("TD_THEME_OPTIONS_NAME", "td_010"); //where to store our options


define("TD_THEME_WP_BOOSTER", "3.0"); //prevents multiple instances of the framework

//if no deploy mode is selected, we use the final deploy built
if (!defined('TD_DEPLOY_MODE')) {
    define("TD_DEPLOY_MODE", 'deploy');
}






switch (TD_DEPLOY_MODE) {
    default:
        //deploy version - this is the version that we ship!
        define("TD_DEBUG_LIVE_THEME_STYLE", false);
        define("TD_DEBUG_IOS_REDIRECT", false);
        define("TD_DEBUG_USE_LESS", false);
        break;

    case 'dev':
        //dev version
        define("TD_DEBUG_LIVE_THEME_STYLE", true);
        define("TD_DEBUG_IOS_REDIRECT", true);
        define("TD_DEBUG_USE_LESS", true); //use less on dev
        break;

    case 'demo':
        //demo version
        define("TD_DEBUG_LIVE_THEME_STYLE", true);
        define("TD_DEBUG_IOS_REDIRECT", true); // remove themeforest iframe from ios devices on demo only!
        define("TD_DEBUG_USE_LESS", false);
        break;
}



/**
 * speed booster v 3.0 hooks - prepare the framework for the theme
 * is also used by td_deploy - that's why it's a static class
 * Class td_wp_booster_hooks
 */
class td_wp_booster_config {


    /**
     * setup the global theme specific variables
     * @depends td_global
     */
    static function td_global_after() {



        /**
         * js files list
         */
        td_global::$js_files = array(
            'td_external' =>            '/includes/wp_booster/js_dev/td_external.js',
            'td_detect' =>              '/includes/wp_booster/js_dev/td_detect.js',
            'td_menu' =>                '/includes/wp_booster/js_dev/td_menu.js',
            'td_local_cache' =>         '/includes/wp_booster/js_dev/td_local_cache.js',
            'td_util' =>                '/includes/wp_booster/js_dev/td_util.js',
            'td_affix' =>               '/includes/wp_booster/js_dev/td_affix.js',
            //'td_scroll_animation' =>    '/includes/wp_booster/js_dev/td_scroll_animation.js',
            'td_site' =>                '/includes/wp_booster/js_dev/td_site.js',
            'td_hash_scroll' =>         '/includes/wp_booster/js_dev/td_hash_scroll.js',
            'td_loading_box' =>         '/includes/wp_booster/js_dev/td_loading_box.js',
            'td_ajax_search' =>          '/includes/wp_booster/js_dev/td_ajax_search.js',
            'td_post_images' =>         '/includes/wp_booster/js_dev/td_post_images.js',
            'td_blocks' =>              '/includes/wp_booster/js_dev/td_blocks.js',
            'td_login' =>               '/includes/wp_booster/js_dev/td_login.js',
            'td_style_customizer' =>    '/includes/wp_booster/js_dev/td_style_customizer.js',
            'td_trending_now' =>        '/includes/wp_booster/js_dev/td_trending_now.js',
            'td_history' =>             '/includes/wp_booster/js_dev/td_history.js',
            'td_smart_sidebar' =>       '/includes/wp_booster/js_dev/td_smart_sidebar.js',
            'td_infinite_loader' =>     '/includes/wp_booster/js_dev/td_infinite_loader.js',
            //'td_smooth_scroll' =>       '/includes/wp_booster/js_dev/td_smooth_scroll.js',

            'td_custom_events' =>       '/includes/js_files/td_custom_events.js',
            'td_events' =>              '/includes/wp_booster/js_dev/td_events.js',

            'td_ajax_count' =>          '/includes/wp_booster/js_dev/td_ajax_count.js',
            'td_video_playlist' =>      '/includes/wp_booster/js_dev/td_video_playlist.js',

            'td_backstretch' =>         '/includes/js_files/td_backstretch.js',

            'td_slide' =>               '/includes/wp_booster/js_dev/td_slide.js',
            'td_pulldown' =>            '/includes/wp_booster/js_dev/td_pulldown.js',

            'td_animation_stack' =>     '/includes/js_files/td_animation_stack.js',
            'td_main' =>                '/includes/js_files/td_main.js',

            'td_last_init' =>           '/includes/wp_booster/js_dev/td_last_init.js',
        );



        /**
         * single template list
         */
        td_api_single_template::add('single_template_1',
            array(
                'file' => td_global::$get_template_directory . '/single_template_1.php',
                'text' => 'Single template 1',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_1.png',
                'show_featured_image_on_all_pages' => false
            )
        );

        td_api_single_template::add('single_template_2',
            array(
                'file' => td_global::$get_template_directory . '/single_template_2.php',
                'text' => 'Single template 2',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_2.png',
                'show_featured_image_on_all_pages' => false
            )
        );

        td_api_single_template::add('single_template_3',
            array(
                'file' => td_global::$get_template_directory . '/single_template_3.php',
                'text' => 'Single template 3',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_3.png',
                'show_featured_image_on_all_pages' => false
            )
        );

        td_api_single_template::add('single_template_4',
            array(
                'file' => td_global::$get_template_directory . '/single_template_4.php',
                'text' => 'Single template 4',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_4.png',
                'show_featured_image_on_all_pages' => true //shows the featured image on all the pages
            )
        );

        td_api_single_template::add('single_template_5',
            array(
                'file' => td_global::$get_template_directory . '/single_template_5.php',
                'text' => 'Single template 5',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_5.png',
                'show_featured_image_on_all_pages' => true //shows the featured image on all the pages
            )
        );

        td_api_single_template::add('single_template_6',
            array(
                'file' => td_global::$get_template_directory . '/single_template_6.php',
                'text' => 'Single template 6',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_6.png',
                'show_featured_image_on_all_pages' => false
            )
        );

        td_api_single_template::add('single_template_7',
            array(
                'file' => td_global::$get_template_directory . '/single_template_7.php',
                'text' => 'Single template 7',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_7.png',
                'show_featured_image_on_all_pages' => false
            )
        );

        td_api_single_template::add('single_template_8',
            array(
                'file' => td_global::$get_template_directory . '/single_template_8.php',
                'text' => 'Single template 8',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_8.png',
                'show_featured_image_on_all_pages' => false
            )
        );



        /**
         * smart lists
         */
        td_api_smart_list::add('td_smart_list_1',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_1.php',
                'text' => 'Smart list 1',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_1.png'
            )
        );

        td_api_smart_list::add('td_smart_list_2',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_2.php',
                'text' => 'Smart list 2',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_2.png'
            )
        );

        td_api_smart_list::add('td_smart_list_3',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_3.php',
                'text' => 'Smart list 3',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_3.png'
            )
        );

        td_api_smart_list::add('td_smart_list_4',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_4.php',
                'text' => 'Smart list 4',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_4.png'
            )
        );



        /**
         * modules list
         */
        td_api_module::add('td_module_1',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_1.php',
                'text' => 'Module 1',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_1.png',
                'used_on_blocks' => array('td_block_3'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_2',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_2.php',
                'text' => 'Module 2',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_2.png',
                'used_on_blocks' => array('td_block_4'),
                'excerpt_title' => 12,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_3',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_3.php',
                'text' => 'Module 3',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_3.png',
                'used_on_blocks' => array('td_block_5'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_4',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_4.php',
                'text' => 'Module 4',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_4.png',
                'used_on_blocks' => array('td_block_1', 'td_block_2'),
                'excerpt_title' => 12,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
	            'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_5',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_5.php',
                'text' => 'Module 5',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_5.png',
                'used_on_blocks' => array('td_block_6'),
                'excerpt_title' => 12,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_6',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_6.php',
                'text' => 'Module 6',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_6.png',
                'used_on_blocks' => array('td_block_1', 'td_block_2', 'td_block_7'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
            )
        );

        td_api_module::add('td_module_7',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_7.php',
                'text' => 'Module 7',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_7.png',
                'used_on_blocks' => array('td_block_8'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_8',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_8.php',
                'text' => 'Module 8',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_8.png',
                'used_on_blocks' => array('td_block_9'),
                'excerpt_title' => 15,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap',     // custom css module class
            )
        );

        td_api_module::add('td_module_9',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_9.php',
                'text' => 'Module 9',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_9.png',
                'used_on_blocks' => array('td_block_10'),
                'excerpt_title' => 15,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap',     // custom css module class
            )
        );

        td_api_module::add('td_module_10',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_10.php',
                'text' => 'Module 10',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_10.png',
                'used_on_blocks' => array('td_block_11'),
                'excerpt_title' => 15,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_11',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_11.php',
                'text' => 'Module 11',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_11.png',
                'used_on_blocks' => array('td_block_12'),
                'excerpt_title' => 15,
                'excerpt_content' => 35,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_12',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_12.php',
                'text' => 'Module 12',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_12.png',
                'used_on_blocks' => '',
                'excerpt_title' => 30,
                'excerpt_content' => 60,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_13',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_13.php',
                'text' => 'Module 13',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_13.png',
                'used_on_blocks' => '',
                'excerpt_title' => 30,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_14',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_14.php',
                'text' => 'Module 14',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_14.png',
                'used_on_blocks' => array('td_block_13'),
                'excerpt_title' => 30,
                'excerpt_content' => 40,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_15',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_15.php',
                'text' => 'Module 15',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_15.png',
                'used_on_blocks' => '',
                'excerpt_title' => 30,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mx1',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx1.php',
                'text' => 'Module MX1',
                'img' => '',
                'used_on_blocks' => array('td_block_14', 'td_block_15'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mx2',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx2.php',
                'text' => 'Module MX2',
                'img' => '',
                'used_on_blocks' => array('td_block_15'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mx3',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx3.php',
                'text' => 'Module MX3',
                'img' => '',
                'used_on_blocks' => array('td_block_13'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mx4',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx4.php',
                'text' => 'Module MX4',
                'img' => '',
                'used_on_blocks' => array('td_block_16'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mx5',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx5.php',
                'text' => 'Module MX5',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mx6',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx6.php',
                'text' => 'Module MX6',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mx_empty',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx_empty.php',
                'text' => 'Module MX Empty',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid'),
                'excerpt_title' => '',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => false,
                'class' => 'td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_related_posts',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_related_posts.php',
                'text' => 'Related posts module',
                'img' => '',
                'used_on_blocks' => array('td_block_related_posts'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_mega_menu',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mega_menu.php',
                'text' => 'Mega menu module',
                'img' => '',
                'used_on_blocks' => array('td_block_mega_menu'),
                'excerpt_title' => '', // the excerpt for mega menu is hardcoded
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => '',     // custom css module class
            )
        );

        td_api_module::add('td_module_slide',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_slide.php',
                'text' => 'Slider module',
                'img' => '',
                'used_on_blocks' => array('td_block_slide'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td-animation-stack',     // custom css module class
            )
        );

        td_api_module::add('td_module_trending_now',
            array(  // this module is for internal use only
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_trending_now.php',
                'text' => 'Trending now module',
                'img' => '',
                'used_on_blocks' => '',
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => false,
                'class' => 'td_module_wrap',     // custom css module class
            )
        );

        td_api_module::add('td_module_single',
            array(  // this module is for internal use only
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_single.php',
                'text' => 'Single Module',
                'img' => '',
                'used_on_blocks' => '',
                'excerpt_title' => '',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => false,
                'class' => '',     // custom css module class
            )
        );



        /**
         * the thumbs used by the theme
         * Thumb id => array parameters. Wp booster only cuts if the option is set from theme panel
         */
        td_api_thumb::add('td_0x420',
            array(
                'name' => 'td_0x420',
                'width' => 0,
                'height' => 420,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal', //what play icon to load (small or normal)
                'used_on' => array(
                    'tagDiv Image Gallery'
                )
            )
        );

        td_api_thumb::add('td_80x60',
            array(
                'name' => 'td_80x60',
                'width' => 80,
                'height' => 60,
                 'crop' => array('center', 'top'),
                'post_format_icon_size' => 'small',
                'used_on' => array(
                    'Block 15', 'Live search'
                )
            )
        );

        td_api_thumb::add('td_100x75',
            array(
                'name' => 'td_100x75',
                'width' => 100,
                'height' => 75,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'small',
                'used_on' => array(
                    'Module 6, 7', 'Block 1, 2, 7, 8'
                )
            )
        );

        td_api_thumb::add('td_180x135',
            array(
                'name' => 'td_180x135',
                'width' => 180,
                'height' => 135,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 10', 'Block 11', 'Mega menu'
                )
            )
        );

        td_api_thumb::add('td_238x178',
            array(
                'name' => 'td_238x178',
                'width' => 238,
                'height' => 178,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 11', 'Block 12', 'Big grid - small image', 'Related articles'
                )
            )
        );

        td_api_thumb::add('td_300x160',
            array(
                'name' => 'td_300x160',
                'width' => 300,
                'height' => 160,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 1, 2', 'Block 3, 4'
                )
            )
        );

        td_api_thumb::add('td_300x194',
            array(
                'name' => 'td_300x194',
                'width' => 300,
                'height' => 194,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 3, 4, 5', 'Block 1, 2, 5, 6, 16'
                )
            )
        );

        td_api_thumb::add('td_300x350',
            array(
                'name' => 'td_300x350',
                'width' => 300,
                'height' => 350,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Post style 1', 'Slide - 1 column', 'Smart list style 3'
                )
            )
        );

        td_api_thumb::add('td_341x220',
            array(
                'name' => 'td_341x220',
                'width' => 341,
                'height' => 220,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Block 13, 14, 15'
                )
            )
        );

        td_api_thumb::add('td_537x360',
            array(
                'name' => 'td_537x360',
                'width' => 537,
                'height' => 360,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Big grid - large image'
                )
            )
        );

        td_api_thumb::add('td_640x0',
            array(
                'name' => 'td_640x0',
                'width' => 640,
                'height' => 0,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Default post template', 'Post style 2', 'Module 12, 13, 15', 'Smart list style 1, 2'
                )
            )
        );

        td_api_thumb::add('td_640x350',
            array(
                'name' => 'td_640x350',
                'width' => 640,
                'height' => 350,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Slide - 2 columns'
                )
            )
        );

        td_api_thumb::add('td_681x0',
            array(
                'name' => 'td_681x0',
                'width' => 681,
                'height' => 0,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Post style 3', 'Module 14', 'Block 13'
                )
            )
        );

        td_api_thumb::add('td_1021x580',
            array(
                'name' => 'td_1021x580',
                'width' => 1021,
                'height' => 580,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Post style 4, 5, 8', 'Slide - 3 columns(full)'
                )
            )
        );



        /**
         * the headers
         */

        td_api_header_style::add('1',
            array(
                'text' => '<strong>Style 1 - </strong> default',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-1.php'
            )
        );

        td_api_header_style::add('2',
            array(
                'text' => '<strong>Style 2 - </strong> logo on colored box',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-2.php'
            )
        );

        td_api_header_style::add('3',
            array(
                'text' => '<strong>Style 3 - </strong> full top menu',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-3.php'
            )
        );

        td_api_header_style::add('4',
            array(
                'text' => '<strong>Style 4 - </strong> logo in menu',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-4.php'
            )
        );

        td_api_header_style::add('5',
            array(
                'text' => '<strong>Style 5 - </strong> logo in full menu on top',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-5.php'
            )
        );

        td_api_header_style::add('6',
            array(
                'text' => '<strong>Style 6 - </strong> top menus + logo and ad',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-6.php'
            )
        );

        td_api_header_style::add('7',
            array(
                'text' => '<strong>Style 7 - </strong> full header logo',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-7.php'
            )
        );

        td_api_header_style::add('8',
            array(
                'text' => '<strong>Style 8 - </strong> full header logo + full menu',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-8.php'
            )
        );

        td_api_header_style::add('9',
            array(
                'text' => '<strong>Style 9 - </strong> full menus + logo in menu',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-9.php'
            )
        );

        td_api_header_style::add('10',
            array(
                'text' => '<strong>Style 10 - </strong> full menu + text logo',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-10.php'
            )
        );



        /**
         * the styles for big grids. This styles will show up in the panel @see td_panel_categories.php and on each big grid block
         * This has to be before the blocks are added! The grids blocks are made with this
         */
        td_global::$big_grid_styles_list = array();



        /**
         * the blocks
         */
        td_api_block::add('td_block_1',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 1',
                "base" => 'td_block_1',
                "class" => 'td_block_1',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_1',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_1.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_2',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 2',
                "base" => 'td_block_2',
                "class" => 'td_block_2',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_2',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_2.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_3',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 3',
                "base" => 'td_block_3',
                "class" => 'td_block_3',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_3',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_3.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_4',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 4',
                "base" => 'td_block_4',
                "class" => 'td_block_4',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_4',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_4.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_5',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 5',
                "base" => 'td_block_5',
                "class" => 'td_block_5',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_5',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_5.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_6',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 6',
                "base" => 'td_block_6',
                "class" => 'td_block_6',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_6',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_6.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_7',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 7',
                "base" => 'td_block_7',
                "class" => 'td_block_7',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_7',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_7.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_8',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 8',
                "base" => 'td_block_8',
                "class" => 'td_block_8',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_8',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_8.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_9',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 9',
                "base" => 'td_block_9',
                "class" => 'td_block_9',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_9',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_9.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_10',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 10',
                "base" => 'td_block_10',
                "class" => 'td_block_10',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_10',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_10.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_11',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 11',
                "base" => 'td_block_11',
                "class" => 'td_block_11',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_11',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_11.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_12',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 12',
                "base" => 'td_block_12',
                "class" => 'td_block_12',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_12',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_12.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_13',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 13',
                "base" => 'td_block_13',
                "class" => 'td_block_13',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_13',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_13.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_14',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 14',
                "base" => 'td_block_14',
                "class" => 'td_block_14',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_14',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_14.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_15',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 15',
                "base" => 'td_block_15',
                "class" => 'td_block_15',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_15',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_15.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_16',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Block 16',
                "base" => 'td_block_16',
                "class" => 'td_block_16',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_16',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_16.php',
                "params" => array_merge(
                    self::get_map_filter_array(),
                    self::get_map_block_array()
                )
            )
        );

        td_api_block::add('td_block_big_grid',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Big Grid',
                "base" => 'td_block_big_grid',
                "class" => 'td_block_big_grid',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_big_grid',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid.php',
                "params" => self::td_block_big_grid_params(),
            )
        );

        td_api_block::add('td_block_trending_now',
            array(
                'map_in_visual_composer' => true,
                "name" => 'News ticker',
                "base" => 'td_block_trending_now',
                "class" => 'td_block_trending_now',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_trending_now',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_trending_now.php',
                "params" => self::td_block_trending_now_params(),
            )
        );

        td_api_block::add('td_block_video_youtube',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Video Playlist',
                "base" => "td_block_video_youtube",
                "class" => "td_block_video_playlist_youtube",
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td-youtube',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_video_youtube.php',
                "params" => array(
                    array(
                        "param_name" => "playlist_title",
                        "type" => "textfield",
                        "value" => "",
                        //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                        "heading" => "Optional - custom title for this block:",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "playlist_yt",
                        "type" => "textfield",
                        "value" => "",
                        //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                        "heading" => "List of youtube id's separated by comma (ex: NRuE38Bl5Mo, 1ZgoluYjuZM, 0K-0vkFfUmY):",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "playlist_auto_play",
                        "type" => "dropdown",
                        "value" => array('OFF' => '0', 'ON' => '1'),
                        //"heading" => __("Select playlist type:", TD_THEME_NAME),
                        "heading" => "Autoplay ON / OFF:",
                        "description" => "Autoplay does not work on mobile devices (android, windows phone, iOS)",
                        "holder" => "div",
                        "class" => ""
                    )
                )
            )
        );

        td_api_block::add('td_block_video_vimeo',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Video Playlist',
                "base" => "td_block_video_vimeo",
                "class" => "td_block_video_playlist_vimeo",
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td-vimeo',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_video_vimeo.php',
                "params" => array(
                    array(
                        "param_name" => "playlist_title",
                        "type" => "textfield",
                        "value" => "",
                        //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                        "heading" => "Optional - custom title for this block:",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "playlist_v",
                        "type" => "textfield",
                        "value" => "",
                        //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                        "heading" => "List of vimeo id's separated by comma (ex: 100888579,  84062802, 57863017):",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "playlist_auto_play",
                        "type" => "dropdown",
                        "value" => array('OFF' => '0', 'ON' => '1'),
                        //"heading" => __("Select playlist type:", TD_THEME_NAME),
                        "heading" => "Autoplay ON / OFF:",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    )
                )
            )
        );

        td_api_block::add('td_block_ad_box',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Ad box',
                "base" => 'td_block_ad_box',
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-ads',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_ad_box.php',
                "params" => array(
                    array(
                        "param_name" => "spot_id",
                        "type" => "dropdown",
                        "value" => array(
                            'sidebar' => 'sidebar',
                            'content_inline' => 'content_inline',
                            'content_top' => 'content_top',
                            'content_bottom' => 'content_bottom',
                            'header' => 'header',
                            'custom_ad_1' => 'custom_ad_1',
                            'custom_ad_2' => 'custom_ad_2',
                            'custom_ad_3' => 'custom_ad_3',
                            'custom_ad_4' => 'custom_ad_4',
                            'custom_ad_5' => 'custom_ad_5'
                        ),
                        "heading" => 'Use adspot :',
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),

                    array(
                        "param_name" => "spot_title",
                        "type" => "textfield",
                        "value" => "",
                        "heading" => 'Ad title:',
                        "description" => "Optional - a title for the Ad, like - Advertisement - if you leave it blank the block will not have a title",
                        "holder" => "div",
                        "class" => ""
                    )
                )
            )
        );

        td_api_block::add('td_block_authors',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Authors box',
                "base" => "td_block_authors",
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_authors',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_authors.php',
                "params" => array(
                    array(
                        "param_name" => "title",
                        "type" => "textfield",
                        "value" => '',
                        "heading" => "Block title",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "sort",
                        "type" => "dropdown",
                        "value" => array('- Sort by name -' => '', 'Sort by post count' => 'post_count'),
                        "heading" => 'Sort authors by:',
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "exclude",
                        "type" => "textfield",
                        "value" => '',
                        "heading" => "Exclude authors id (, separated)",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "include",
                        "type" => "textfield",
                        "value" => '',
                        "heading" => "Include authors id (, separated) - do not use with exclude",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Header color',
                        "param_name" => "header_color",
                        "value" => '', //Default Red color
                        "description" => 'Choose a custom header color for this block'
                    ),
                )
            )
        );

        td_api_block::add('td_block_homepage_full_1',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Homepage post',
                "base" => 'td_block_homepage_full_1',
                "class" => 'td_block_homepage_full_1',
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_homepage_full_1',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_homepage_full_1.php',
                "params" => self::td_homepage_full_1_params()
            )
        );

        td_api_block::add('td_block_popular_categories',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Popular category',
                "base" => "td_block_popular_categories",
                "class" => "td_block_popular_categories",
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-popular_categories',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_popular_categories.php',
                "params" => array(
                    array(
                        "param_name" => "custom_title",
                        "type" => "textfield",
                        "value" => "POPULAR CATEGORIES",
                        "heading" => 'Optional - custom title for this block:',
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "custom_url",
                        "type" => "textfield",
                        "value" => "",
                        "heading" => 'Optional - custom url for this block (when the module title is clicked):',
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Header color',
                        "param_name" => "header_color",
                        "value" => '', //Default Red color
                        "description" => 'Choose a custom header color for this block'
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Header text color',
                        "param_name" => "header_text_color",
                        "value" => '', //Default Red color
                        "description" => 'Choose a custom header color for this block'
                    ),
                    array(
                        "param_name" => "limit",
                        "type" => "textfield",
                        "value" => "6",
                        "heading" => 'Limit the number of categories shown:',
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    )
                )
            )
        );

        td_api_block::add('td_block_slide',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Slide',
                "base" => "td_block_slide",
                "class" => "td_block_slide",
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-slide',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_slide.php',
                "params" => self::td_slide_params()
            )
        );

        td_api_block::add('td_block_text_with_title',
            array(
                'map_in_visual_composer' => true,
                "name" => 'Text with title',
                "base" => "td_block_text_with_title",
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
                'icon' => 'icon-pagebuilder-title',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_text_with_title.php',
                "params" => array(
                    array(
                        "param_name" => "custom_title",
                        "type" => "textfield",
                        "value" => '',
                        "heading" => "Block title",
                        "description" => "",
                        "holder" => "div",
                        "class" => ""
                    ),
                    array(
                        "param_name" => "content",
                        "type" => "textarea_html",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Text',
                        "value" => "",
                        "description" => 'Enter your content.'
                    ),
                    array(
                        "param_name" => "border_top",
                        "type" => "dropdown",
                        "value" => array('- With border -' => '', 'no border' => 'no_border_top'),
                        "heading" => 'Border top:',
                        "description" => "By default all the blocks have a border at the top. You may wish to remove that in some cases (like when the block it's the first in a sidebar)",
                        "holder" => "div",
                        "class" => ""
                    ),

                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Header color',
                        "param_name" => "header_color",
                        "value" => '', //Default Red color
                        "description" => 'Choose a custom header color for this block'
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Header text color',
                        "param_name" => "header_text_color",
                        "value" => '', //Default Red color
                        "description" => 'Choose a custom header color for this block'
                    )
                )
            )
        );

        td_api_block::add('td_block_related_posts',
            array(
                'map_in_visual_composer' => false,
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_related_posts.php',
            )
        );

        td_api_block::add('td_block_mega_menu',
            array(
                'map_in_visual_composer' => false,
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_mega_menu.php',
	            'render_atts' => array(
		            'show_child_cat' => 5,
	            )
            )
        );



        /**
         * block templates
         */
        td_api_block_template::add('td_block_template_1',
            array (
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_1.php',
            )
        );


        /**
         * category templates
         */
        td_api_category_template::add('td_category_template_1',
            array (
                'file' => td_global::$get_template_directory . '/includes/category_templates/td_category_template_1.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/category_templates/icon-category-1.png',
                'text' => 'Style 1'
            )
        );

        td_api_category_template::add('td_category_template_2',
            array (
                'file' => td_global::$get_template_directory . '/includes/category_templates/td_category_template_2.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/category_templates/icon-category-2.png',
                'text' => 'Disable'
            )
        );


        /**
         * category top posts styles
         */
        td_api_category_top_posts_style::add('td_category_top_posts_style_1',
            array (
                'file' => td_global::$get_template_directory . '/includes/category_top_posts_styles/td_category_top_posts_style_1.php',
                'posts_shown_in_the_loop' => 5,
                'img' => td_global::$get_template_directory_uri . '/images/panel/category_templates/icon-category-top-1.png',
                'text' => 'Style 1',
                'td_block_name' => 'td_block_big_grid'
            )
        );

        td_api_category_top_posts_style::add('td_category_top_posts_style_2',
            array (
                'file' => td_global::$get_template_directory . '/includes/category_top_posts_styles/td_category_top_posts_style_2.php',
                'posts_shown_in_the_loop' => 0,
                'img' => td_global::$get_template_directory_uri . '/images/panel/category_templates/icon-category-top-2.png',
                'text' => 'Disable',
                'td_block_name' => ''
            )
        );



        /**
         * the td_api_top_bar_template
         */
        /*
        td_api_top_bar_template::add('td_top_bar_template_1',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_1.png',
                'file' => td_global::$get_template_directory . '/parts/header/td_top_bar_template_1.php'
            )
        );
        */




        /**
         * the td_api_footer
         */
        td_api_footer_template::add('td_footer_template_1',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-1.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_1.php',
                'text' => 'Style 1'
            )
        );

        td_api_footer_template::add('td_footer_template_2',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-2.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_2.php',
                'text' => 'Style 2'
            )
        );

        td_api_footer_template::add('td_footer_template_3',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-3.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_3.php',
                'text' => 'Style 3'
            )
        );

        td_api_footer_template::add('td_footer_template_4',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-4.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_4.php',
                'text' => 'Style 4'
            )
        );

        td_api_footer_template::add('td_footer_template_5',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-5.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_5.php',
                'text' => 'Style 5'
            )
        );

        td_api_footer_template::add('td_footer_template_6',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-6.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_6.php',
                'text' => 'Style 6'
            )
        );

        td_api_footer_template::add('td_footer_template_7',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-7.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_7.php',
                'text' => 'Style 7'
            )
        );

        td_api_footer_template::add('td_footer_template_8',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-8.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_8.php',
                'text' => 'Style 8'
            )
        );

        td_api_footer_template::add('td_footer_template_9',
            array(
                'img' => td_global::$get_template_directory_uri . '/images/panel/footer_templates/icon-footer-9.png',
                'file' => td_global::$get_template_directory . '/parts/footer/td_footer_template_9.php',
                'text' => 'Style 9'
            )
        );


        /**
         * set the custom css fields for the panel @see td_panel_custom_css.php
         * and also for the wp_footer hook @see td_bottom_code()
         */
        td_global::$theme_panel_custom_css_fields_list = array(
            'tds_responsive_css_desktop' => array(
                'text' => 'DESKTOP',
                'description' => '1024px +',
                'media_query' => '@media (min-width: 1200px)',
                'img' => td_global::$get_template_directory_uri . '/includes/wp_booster/wp-admin/images/panel/resp-desktop.png'
            ),
            'tds_responsive_css_ipad_portrait' => array(
                'text' => 'IPAD PORTRAIT',
                'description' => '768 - 1023px',
                'media_query' => '@media (min-width: 768px) and (max-width: 1018px)',
                'img' => td_global::$get_template_directory_uri . '/includes/wp_booster/wp-admin/images/panel/resp-ipadv.png'
            ),
            'tds_responsive_css_phone' => array(
                'text' => 'PHONES',
                'description' => '0 - 767px',
                'media_query' => '@media (max-width: 767px)',
                'img' => td_global::$get_template_directory_uri . '/includes/wp_booster/wp-admin/images/panel/resp-phone.png'
            )
        );



        /**
         * The typography settings for the panel and css compiler
         */
        td_global::$typography_settings_list = array (
            'Header' => array (
                'top_menu' => 'Top Menu',
                'top_sub_menu' => 'Top Sub-Menu',
                'main_menu' => 'Main Menu',
                'main_sub_menu' => 'Main Sub-Menu',
                'mega_menu' => 'Mega Menu',
                'mega_menu_categ' => 'Mega Menu Sub-Categories',
                'mobile_menu' => 'Mobile Menu',
                'mobile_sub_menu' => 'Mobile Sub-Menu',
            ),
            'Modules and Blocks General' => array (
                'blocks_title' => 'Blocks/Widgets Title',
                'blocks_author' => 'Author',
                'blocks_date' => 'Date',
                'blocks_comment' => 'Comment',
                'blocks_category' => 'Category tag',
                'blocks_filter' => 'Filter dropdown',
                'blocks_excerpt' => 'Excerpt',
            ),
            'Modules and Blocks Article Title' => array (
                'module_1' => 'Module 1',
                'module_2' => 'Module 2',
                'module_3' => 'Module 3',
                'module_4' => 'Module 4',
                'module_5' => 'Module 5',
                'module_6' => 'Module 6',
                'module_7' => 'Module 7',
                'module_8' => 'Module 8',
                'module_9' => 'Module 9',
                'module_10' => 'Module 10',
                'module_11' => 'Module 11',
                'module_12' => 'Module 12',
                'module_13' => 'Module 13',
                'module_14' => 'Module 14',
                'module_15' => 'Module 15',
                'module_mx1' => 'Module MX1',
                'module_mx2' => 'Module MX2',
                'module_mx3' => 'Module MX3',
                'module_mx4' => 'Module MX4',
                'news_ticker' => 'News Ticker',
                'big_grid_large_image' => 'Big Grid Large Image',
                'big_grid_small_images' => 'Big Grid Small Images',
                'slider_1column' => 'Slider on 3 columns',
                'slider_2columns' => 'Slider on 2 columns',
                'slider_3columns' => 'Slider 1 column',
                'homepage_post' => 'Homepage post',
            ),
            'Post title' => array (
                'post_title' => 'Default template',
                'post_title_style1' => 'Style 1 template',
                'post_title_style2' => 'Style 2 template',
                'post_title_style3' => 'Style 3 template',
                'post_title_style4' => 'Style 4 template',
                'post_title_style5' => 'Style 5 template',
                'post_title_style6' => 'Style 6 template',
                'post_title_style7' => 'Style 7 template',
                'post_title_style8' => 'Style 8 template',
            ),
            'Post content' => array (
                'post_content' => 'Post Content',
                'post_box_quote' => 'Box Quote',
                'post_pull_quote' => 'Pull Quote',
                'post_blockquote' => 'Default Blockquote',
                'post_h1' => 'H1',
                'post_h2' => 'H2',
                'post_h3' => 'H3',
                'post_h4' => 'H4',
                'post_h5' => 'H5',
                'post_h6' => 'H6',
            ),
            'Post elements' => array (
                'post_category' => 'Category tag',
                'post_author' => 'Author',
                'post_date' => 'Date',
                'post_comment' => 'Views and Comments',
                'via_source_tag' => 'Via/Source/Tags',
                'post_next_prev_text' => 'Next/Prev Text',
                'post_next_prev' => 'Next/Prev Post Title',
                'box_author_name' => 'Box Author Name',
                'box_author_url' => 'Box Author URL',
                'box_author_description' => 'Box Author Description',
                'post_related' => 'Related Article Title',
                'post_share' => 'Share Text',
                'post_image_caption' => 'Image caption',
                'post_subtitle_small' => 'Subtitle for post style Default, 1, 5, 7, 8',
                'post_subtitle_large' => 'Subtitle for post style 2, 3, 4, 6',
            ),
            'Pages' => array (
                'page_title' => 'Page title',
                'page_content' => 'Page content',
                'page_h1' => 'H1',
                'page_h2' => 'H2',
                'page_h3' => 'H3',
                'page_h4' => 'H4',
                'page_h5' => 'H5',
                'page_h6' => 'H6',
            ),
            'Footer' => array (
                'footer_text_about' => 'Text under logo',
                'footer_copyright_text' => 'Copyright text',
                'footer_menu_text' => 'Footer menu',
            ),
            'Other' => array (
                'breadcrumb' => 'Breadcrumb',
                'category_tag' => 'Sub-Category tags from Category pages',
                'news_ticker_title' => 'News Ticker title',
                'pagination' => 'Pagination',
                'dropcap' => 'Dropcap',
                'default_widgets' => 'Default Widgets',
                'default_buttons' => 'Default Buttons',
                'woocommerce_products' => 'Woocommerce products titles',
                'woocommerce_product_title' => 'Woocommerce product title on product page',
            ),
            'Body' => array (
                'body_text' => 'Body - General font',
            ),
            'bbPress - Forum' => array (
                'bbpress_header' => 'Header',
                'bbpress_titles' => 'Forums and Topics Titles',
                'bbpress_subcategories' => 'Subcategories Titles',
                'bbpress_description' => 'Categories Description',
                'bbpress_author' => 'Author name',
                'bbpress_replies' => 'Replies content',
                'bbpress_notices' => 'Notices/Messages',
                'bbpress_pagination' => 'Pagination text',
                'bbpress_topic' => 'Topic details'
            ),
        ); // end td_global::$typography_settings_list






        if (is_admin()) {

            /**
             * the text for wp-admin -> new post -> featured video box. Usually is the text that tells what post templates support video
             */
            td_global::$text_wp_admin_featured_video = '
                <div class="td-wpa-info"> Paste a link from Vimeo or Youtube, it will be embedded in the post and the thumb used as the featured image of this post</div>
                <div class="td-wpa-info"><strong>Notice:</strong> Use only with those post templates: <ul><li>Post style default</li> <li>Post style 1</li> <li>Post style 2</li> <li>Post style 3</li> <li>Post style 8</li></ul></div>
            ';




            /**
             * the tiny mce image style list
             */
            td_global::$tiny_mce_image_style_list = array(
                'td_full_width' => array(
                    'text' => 'Full width',
                    'class' => 'td-post-image-full'
                ),
                'td_full_width_and_grid' => array(
                    'text' => 'Full width and grid border',
                    'class' => 'td-post-image-full-and-grid'
                ),
                'td_left' => array(
                    'text' => 'Left ( Over grid )',
                    'class' => 'td-post-image-left'
                ),
                'td_right' => array(
                    'text' => 'Right ( Over grid )',
                    'class' => 'td-post-image-right'
                )
            );



            /**
             * the tiny mce styles
             */
            td_global::$tiny_mce_style_formats = array(
                array(
                    'title' => 'Text padding',
                    'items' => array (
                        array(
                            'title' => 'text ⇠',
                            'block' => 'div',
                            'classes' => 'td-paragraph-padding-0',
                            'wrapper' => true,
                            //'icon' => 'td-test-icons'
                        ),
                        array(
                            'title' => '⇢ text',
                            'block' => 'div',
                            'classes' => 'td-paragraph-padding-4',
                            'wrapper' => true,
                        ),
                        array(
                            'title' => '⇢ text ⇠',
                            'block' => 'div',
                            'classes' => 'td-paragraph-padding-1',
                            'wrapper' => true,
                        ),
                        array(
                            'title' => '⇢ text ⇠⇠',
                            'block' => 'div',
                            'classes' => 'td-paragraph-padding-3',
                            'wrapper' => true,
                        ),
                        array(
                            'title' => '⇢⇢ text ⇠',
                            'block' => 'div',
                            'classes' => 'td-paragraph-padding-6',
                            'wrapper' => true,
                        ),
                        array(
                            'title' => '⇢⇢ text ⇠⇠',
                            'block' => 'div',
                            'classes' => 'td-paragraph-padding-2',
                            'wrapper' => true,
                        ),
                        array(
                            'title' => '⇢⇢⇢ text ⇠⇠⇠',
                            'block' => 'div',
                            'classes' => 'td-paragraph-padding-5',
                            'wrapper' => true,
                        ),
                    )
                ),
                array(
                    'title' => 'Arrow list',
                    'selector' => 'ul',
                    'classes' => 'td-arrow-list'
                ),
            );



            /**
             * the stacks are stored in /includes/stacks
             * stack_filename (without .txt) => stack_name
             * @var array
             */
            td_global::$stacks_list = array(
                'classic_blog' => 'Classic blog',
                'fashion' => 'Fashion',
                'sport' => 'Sport',
                'tech' => 'Tech',
                'video' => 'Video',
            );






        } // end if is_admin


    } // end hook

	/**
	 * the filter array (used by blocks and by the loop filters)
	 * @return array
	 */
	static function get_map_filter_array () {
		return array(
			array(
				"param_name" => "category_id",
				"type" => "dropdown",
				"value" => td_util::get_category2id_array(),
				"heading" => 'Category filter:',
				"description" => "A single category filter. If you want to filter multiple categories, use the 'Multiple categories filter' and leave this to default",
				"holder" => "div",
				"class" => ""
			),
			array(
				"param_name" => "category_ids",
				"type" => "textfield",
				"value" => '',
				"heading" => 'Multiple categories filter:',
				"description" => "Filter multiple categories by ID. Enter here the category IDs separated by commas (ex: 13,23,18). To exclude categories from this block add them with '-' (ex: -9, -10)",
				"holder" => "div",
				"class" => ""
			),
			array(
				"param_name" => "tag_slug",
				"type" => "textfield",
				"value" => '',
				"heading" => 'Filter by tag slug:',
				"description" => "To filter multiple tag slugs, enter here the tag slugs separated by commas (ex: tag1,tag2,tag3)",
				"holder" => "div",
				"class" => ""
			),
//			array(
//				"param_name" => "autors_id",
//				"type" => "dropdown",
//				"value" => td_util::create_array_authors(),
//				"heading" => "Authors Filter:",
//				"description" => "Filter by author. Shows only posts made by this author",
//				"holder" => "div",
//				"class" => ""
//			),
			array(
				"param_name" => "autors_id",
				"type" => "textfield",
				"value" => '',
				"heading" => "Multiple authors filter:",
				"description" => "Filter multiple authors by ID. Enter here the category IDs separated by commas (ex: 13,23,18).",
				"holder" => "div",
				"class" => ""
			),
			array(
				"param_name" => "sort",
				"type" => "dropdown",
				"value" => array('- Latest -' => '', 'Random posts Today' => 'random_today' , 'Random posts from last 7 Day' => 'random_7_day' , 'Alphabetical A -> Z' => 'alphabetical_order', 'Popular (all time)' => 'popular', 'Popular (last 7 days; enable first from ' . TD_THEME_NAME . ' Panel -> Block settings -> 7 days post sorting)' => 'popular7' , 'Featured' => 'featured', 'Highest rated (reviews)' => 'review_high', 'Random Posts' => 'random_posts', 'Most Commented' => 'comment_count'),
				"heading" => 'Sort order:',
				"description" => "How to sort the posts.",
				"holder" => "div",
				"class" => ""
			)
		,
			array(
				"param_name" => "installed_post_types",
				"type" => "textfield",
				"value" =>  '',//td_util::create_array_installed_post_types(),
				"heading" => 'Post Type:',
				"description" => "Filter by post types. Usage: post OR post,events,pages ; write 1 or more post types delimited by commas",
				"holder" => "div",
				"class" => ""
			),
			array(
				"param_name" => "limit",
				"type" => "textfield",
				"value" => '5',
				"heading" => 'Limit post number:',
				"description" => "If the field is empty the limit post number will be the number from Wordpress settings -> Reading",
				"holder" => "div",
				"class" => ""
			),
			array(
				"param_name" => "offset",
				"type" => "textfield",
				"value" => '',
				"heading" => 'Offset posts:',
				"description" => "Start the count with an offset. If you have a block that shows 5 posts before this one, you can make this one start from the 6'th post (by using offset 5)",
				"holder" => "div",
				"class" => ""
			)
		);//end generic array
	}//end get_map function


	/**
	 * This array is used only by blocks that have loops + title (it is merged with the array from get_map_filter_array)
	 * @return array
	 */
	static function get_map_block_array() {
		return array(
			// title settings
			array(
				"param_name" => "custom_title",
				"type" => "textfield",
				"value" => "Block title",
				"heading" => 'Custom title for this block:',
				"description" => "Optional - a title for this block, if you leave it blank the block will not have a title",
				"holder" => "div",
				"class" => ""
			),
			array(
				"param_name" => "custom_url",
				"type" => "textfield",
				"value" => "",
				"heading" => 'Title url:',
				"description" => "Optional - a custom url when the block title is clicked",
				"holder" => "div",
				"class" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => 'Title text color',
				"param_name" => "header_text_color",
				"value" => '', //Default Red color
				"description" => 'Optional - Choose a custom title text color for this block'
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => 'Title background color',
				"param_name" => "header_color",
				"value" => '', //Default Red color
				"description" => 'Optional - Choose a custom title background color for this block'
			),

			// appearance settings
			array(
				"param_name" => "border_top",
				"type" => "dropdown",
				"value" => array('- With border -' => '', 'no border' => 'no_border_top'),
				"heading" => 'Border top:',
				"description" => "By default all the blocks have a border at the top. You may wish to remove that in some cases (like when the block it's the first in a sidebar)",
				"holder" => "div",
				"class" => ""
			),

			array(
				"param_name" => "color_preset",
				"type" => "dropdown",
				"value" => array('- Default -' => '', 'Style 1 - Red' => 'td-block-color-style-1', 'Style 2 - Black' => 'td-block-color-style-2', 'Style 3 - Orange' => 'td-block-color-style-3', 'Style 4 - Yellow' => 'td-block-color-style-4', 'Style 5 - Green' => 'td-block-color-style-5', 'Style 6 - Pink' => 'td-block-color-style-6'),
				"heading" => 'Color preset (background style):',
				"description" => "Choose a color preset for this block. You can customize the presets in Theme panel -> Block settings.",
				"holder" => "div",
				"class" => ""
			),


			//custom filter types
			array(
				"param_name" => "td_ajax_filter_type", //this is used to build the filter list (for example a list of categories from the id-s bellow)
				"type" => "dropdown",
				"value" => array('- No drop down ajax filter -' => '', 'Filter by categories' => 'td_category_ids_filter', 'Filter by authors' => 'td_author_ids_filter', 'Filter by tag slug' => 'td_tag_slug_filter', 'Filter by popularity (Featured | All time popular)' => 'td_popularity_filter_fa'),
				"heading" => 'Ajax dropdown - filter type:',
				"description" => "Show the ajax drop down filter. The ajax filters (except by popularity) require an additional parameter. If no ids are provided in the input below, the filter will show all the available items (ex: all authors, all categories etc..)",
				"holder" => "div",
				"class" => ""
			),

			//filter by ids
			array(
				"param_name" => "td_ajax_filter_ids", //the ids that we will show in the list
				"type" => "textfield",
				"value" => '',
				"heading" => 'Ajax dropdown - show the following IDs:',
				"description" => "The ajax drop down shows only the (author ids, categories ids OR tag slugs) that you enter here separated by comas",
				"holder" => "div",
				"class" => ""
			),

			//default pull down text
			array(
				"param_name" => "td_filter_default_txt",
				"type" => "textfield",
				"value" => 'All',
				"heading" => 'Ajax dropdown - Filter default text',
				"description" => "The default text for the first item from the drop down. The first item shows the default block settings",
				"holder" => "div",
				"class" => ""
			),



			array(
				"param_name" => "ajax_pagination",
				"type" => "dropdown",
				"value" => array('- No pagination -' => '', 'Next Prev ajax' => 'next_prev', 'Load More button' => 'load_more', 'Infinite load' => 'infinite'),
				"heading" => 'Pagination:',
				"description" => "Our blocks support pagination.",
				"holder" => "div",
				"class" => ""
			),


			array(
				"param_name" => "ajax_pagination_infinite_stop",
				"type" => "textfield",
				"value" => '',
				"heading" => "Infinite load show 'Load more' after x pages:",
				"description" => "ONLY FOR INFINITE LOAD pagination: Shows 'load more' button after x number of pages. Leave this blank to load posts forever when infinite load is set for ajax pagination",
				"holder" => "div",
				"class" => ""
			)
		);//end generic array
	}


    /**
     * Map array for big grids
     * @return array VC_MAP params
     */
    private static function td_block_big_grid_params() {
        $map_filter_array = self::get_map_filter_array();
        $map_filter_array = td_util::vc_array_remove_params($map_filter_array, array(
            'limit'
        ));
        return $map_filter_array;
    }


    /**
     * Map array for trending now
     * @return array VC_MAP params
     */
    private static function td_block_trending_now_params() {
        $map_block_array = self::get_map_filter_array();

        //move on the first position the new filter array - array_unshift is used to keep the 0 1 2 index. array_marge does not do that
        array_unshift(
            $map_block_array,
            array(
                "param_name" => "navigation",
                "type" => "dropdown",
                "value" => array('Auto' => '', 'Manual' => 'manual'),
                "heading" => 'Navigation:',
                "description" => "If set on `Auto` will set the `Trending Now` block to auto start rotating posts",
                "holder" => "div",
                "class" => ""
            ),

            array(
                "param_name" => "style",
                "type" => "dropdown",
                "value" => array('Default' => '', 'Style 2' => 'style2'),
                "heading" => 'Style:',
                "description" => "Style of the `Trending Now` box",
                "holder" => "div",
                "class" => ""
            )
        );

        return $map_block_array;
    }


    /**
     * Map array for td_homepage_full_1_params
     * @return array VC_MAP params
     */
    private static function td_homepage_full_1_params() {
        $temp_array_filter = self::get_map_filter_array();
        $temp_array_filter = td_util::vc_array_remove_params($temp_array_filter, array(
            'limit',
            'offset'
        ));

        return $temp_array_filter;
    }


    /**
     * Map array for sliders
     * @return array VC_MAP params
     */
    private static function td_slide_params() {
        $map_block_array = self::get_map_block_array();

        // remove some of the params that are not needed for the slide
        $map_block_array = td_util::vc_array_remove_params($map_block_array, array(
            'border_top',
            'color_preset',
            'ajax_pagination',
            'ajax_pagination_infinite_stop'
        ));

        // add some more
        $temp_array_merge = array_merge(
            array(
                array(
                    "param_name" => "autoplay",
                    "type" => "textfield",
                    "value" => '',
                    "heading" => 'Autoplay slider (at x seconds)',
                    "description" => "Leave empty do disable autoplay",
                    "holder" => "div",
                    "class" => ""
                )
            ),
            self::get_map_filter_array(),
            $map_block_array
        );
        return $temp_array_merge;
    }



    /**
     * hook up, is called at EOF
     */
    static function hook() {
        add_action('td_global_after', array('td_wp_booster_config', 'td_global_after'), 9); //we run on 9 priority to allow plugins to updage_key our apis while using the default priority of 10
    }
}

td_wp_booster_config::hook();